/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.nfa.PureNFA;
import com.oracle.truffle.regex.tregex.nfa.PureNFAIndex;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public final class PureNFAMap {
    private final RegexAST ast;
    private final PureNFA root;
    private final PureNFAIndex lookArounds;
    private int prefixLength = 0;
    private StateSet<PureNFAIndex, PureNFA>[] prefixLookbehindEntries;

    public PureNFAMap(RegexAST ast, PureNFA root, PureNFAIndex lookArounds) {
        this.ast = ast;
        this.root = root;
        this.lookArounds = lookArounds;
    }

    public RegexAST getAst() {
        return this.ast;
    }

    public PureNFA getRoot() {
        return this.root;
    }

    public PureNFAIndex getLookArounds() {
        return this.lookArounds;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public RegexASTSubtreeRootNode getASTSubtree(PureNFA nfa) {
        return nfa == this.root ? this.ast.getRoot().getSubTreeParent() : (RegexASTSubtreeRootNode)this.ast.getLookArounds().get(nfa.getSubTreeId());
    }

    public CodePointSet getMergedInitialStateCharSet(CompilationBuffer compilationBuffer) {
        CodePointSetAccumulator acc = compilationBuffer.getCodePointSetAccumulator1();
        if (this.mergeInitialStateMatcher(this.root, acc)) {
            return acc.toCodePointSet();
        }
        return null;
    }

    private boolean mergeInitialStateMatcher(PureNFA nfa, CodePointSetAccumulator acc) {
        block6: for (PureNFATransition t : (PureNFATransition[])nfa.getUnAnchoredInitialState().getSuccessors()) {
            PureNFAState target = t.getTarget();
            switch (target.getKind()) {
                case 0: {
                    continue block6;
                }
                case 3: 
                case 4: {
                    return false;
                }
                case 2: {
                    if (!target.isLookAroundNegated() && !target.isLookBehind(this.ast) && this.mergeInitialStateMatcher((PureNFA)this.lookArounds.get(target.getLookAroundId()), acc)) continue block6;
                    return false;
                }
                case 1: {
                    acc.addSet(target.getCharSet());
                    continue block6;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }
        return true;
    }

    public void addPrefixLookBehindEntry(PureNFA lookBehind, int offset) {
        int i;
        if (this.prefixLookbehindEntries == null || this.prefixLookbehindEntries.length < offset) {
            int length = Integer.highestOneBit(offset);
            if (length < offset) {
                length *= 2;
            }
            assert (length >= offset);
            StateSet[] stateSetArray = this.prefixLookbehindEntries = this.prefixLookbehindEntries == null ? new StateSet[length] : Arrays.copyOf(this.prefixLookbehindEntries, length);
        }
        if (this.prefixLookbehindEntries[i = offset - 1] == null) {
            this.prefixLookbehindEntries[i] = StateSet.create(this.lookArounds);
        }
        this.prefixLookbehindEntries[i].add(lookBehind);
        this.prefixLength = Math.max(this.prefixLength, offset);
    }

    public JsonValue toJson() {
        return Json.obj(Json.prop("root", this.root.toJson(this.ast)), Json.prop("lookArounds", this.lookArounds.stream().map(x -> x.toJson(this.ast))));
    }
}

